//=============================================================================
//
// _[ [renderer.cpp]
// Author : KENSUKE WATANABE
//
//=============================================================================
#include "main.h"
#include "renderer.h"
#include "scene.h"
#include "manager.h"
#include "camera.h"
#include "inputKeyboard.h"
#include "debugStr.h"

// ======== ======== ======== ======== ======== ======== ======== ========
// ÓIoϐ
// -------- -------- -------- -------- -------- -------- -------- --------
LPDIRECT3DDEVICE9 CRenderer::m_pD3DDevice = nullptr;

// ======== ======== ======== ======== ======== ======== ======== ========
// CRenderer::RXgN^
// -------- -------- -------- -------- -------- -------- -------- --------
CRenderer::CRenderer() : m_screenSize(D3DXVECTOR2(SCREEN_WIDTH, SCREEN_HEIGHT))
{
	// l̃NA
	m_pD3D = nullptr;			// Direct3DIuWFNg
	m_pD3DDevice = nullptr;		// DeviceIuWFNg(`ɕKv)
}

// ======== ======== ======== ======== ======== ======== ======== ========
// CEnemy::fXgN^
// -------- -------- -------- -------- -------- -------- -------- --------
CRenderer::~CRenderer()
{

}

//=============================================================================
// 
//=============================================================================
HRESULT CRenderer::Init(HWND hWnd, bool bWindow)
{
	D3DPRESENT_PARAMETERS d3dpp;
	D3DDISPLAYMODE d3ddm;

	// Direct3DIuWFNg̍쐬
	m_pD3D = Direct3DCreate9(D3D_SDK_VERSION);
	if(m_pD3D == nullptr)
	{
		return E_FAIL;
	}

	// ݂̃fBXvC[h擾
	if(FAILED(m_pD3D->GetAdapterDisplayMode(D3DADAPTER_DEFAULT, &d3ddm)))
	{
		return E_FAIL;
	}

	// foCX̃v[e[Vp[^̐ݒ
	ZeroMemory(&d3dpp, sizeof(d3dpp));								// [N[NA
	d3dpp.BackBufferCount			 = 1;							// obNobt@̐
	d3dpp.BackBufferWidth			 = SCREEN_WIDTH;				// Q[ʃTCY()
	d3dpp.BackBufferHeight			 = SCREEN_HEIGHT;				// Q[ʃTCY()
	d3dpp.BackBufferFormat			 = d3ddm.Format;				// J[[h̎w
	d3dpp.SwapEffect				 = D3DSWAPEFFECT_DISCARD;		// fMɓătbv
	d3dpp.EnableAutoDepthStencil	 = TRUE;						// fvXobt@iyobt@jƃXeVobt@쐬
	d3dpp.AutoDepthStencilFormat	 = D3DFMT_D16;					// fvXobt@Ƃ16bitg
	d3dpp.Windowed					 = bWindow;						// EBhE[h
	d3dpp.FullScreen_RefreshRateInHz = D3DPRESENT_RATE_DEFAULT;		// tbV[g
	d3dpp.PresentationInterval       = D3DPRESENT_INTERVAL_DEFAULT;	// C^[o

	// fBXvCA_v^\߂̃foCX쐬
	// `ƒ_n[hEFAōsȂ
	if(FAILED(m_pD3D->CreateDevice(D3DADAPTER_DEFAULT, 
									D3DDEVTYPE_HAL, 
									hWnd, 
									D3DCREATE_HARDWARE_VERTEXPROCESSING, 
									&d3dpp, &m_pD3DDevice)))
	{
		// L̐ݒ肪s
		// `n[hEFAōsA_CPUōsȂ
		if(FAILED(m_pD3D->CreateDevice(D3DADAPTER_DEFAULT, 
										D3DDEVTYPE_HAL, 
										hWnd, 
										D3DCREATE_SOFTWARE_VERTEXPROCESSING, 
										&d3dpp, &m_pD3DDevice)))
		{
			// L̐ݒ肪s
			// `ƒ_CPUōsȂ
			if(FAILED(m_pD3D->CreateDevice(D3DADAPTER_DEFAULT, 
											D3DDEVTYPE_REF, hWnd, 
											D3DCREATE_SOFTWARE_VERTEXPROCESSING, 
											&d3dpp, &m_pD3DDevice)))
			{
				// s
				return E_FAIL;
			}
		}
	}

	// _[Xe[g̐ݒ
	m_pD3DDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW);				// JOsȂ
	m_pD3DDevice->SetRenderState(D3DRS_ZENABLE, TRUE);						// Zobt@gp
	m_pD3DDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE);				// uhs
	m_pD3DDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);		// \[XJ[̎w
	m_pD3DDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);	// fXeBl[VJ[̎w

	// Tv[Xe[g̐ݒ
	m_pD3DDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_WRAP);	// eNX`tľJԂݒ
	m_pD3DDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_WRAP);	// eNX`uľJԂݒ
	m_pD3DDevice->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR);	// eNX`g厞̕Ԑݒ
	m_pD3DDevice->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR);	// eNX`k̕Ԑݒ

	// eNX`Xe[WXe[g̐ݒ
	m_pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1);	// At@ufBO(lD3DTOP_SELECTARG1)
	m_pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);		// ŏ̃At@(lD3DTA_TEXTUREAeNX`ȂꍇD3DTA_DIFFUSE)
	m_pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_CURRENT);		// QԖڂ̃At@(lD3DTA_CURRENT)

	return S_OK;
}

//=============================================================================
// I
//=============================================================================
void CRenderer::Uninit(void)
{
	// foCX̔j
	if(m_pD3DDevice != nullptr)
	{
		m_pD3DDevice->Release();
		m_pD3DDevice = nullptr;
	}

	// Direct3DIuWFNg̔j
	if(m_pD3D != nullptr)
	{
		m_pD3D->Release();
		m_pD3D = nullptr;
	}
}

//=============================================================================
// `̐擪ɍs 
//=============================================================================
bool CRenderer::DrawBigin(void)
{
	// obNobt@yobt@̃NA
	m_pD3DDevice->Clear(0, nullptr, (D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER), D3DCOLOR_RGBA(0, 0, 0, 255), 1.f, 0);
	
	// C[t[̐؂ւ(؂ւɎgp{^)
	DrawWireframe(DIK_1);

	// Direct3Dɂ`̊Jn
	if(SUCCEEDED(m_pD3DDevice->BeginScene()) != 0)
	{
		// sꍇ̓obNobt@ƃtgobt@̓ւ
		m_pD3DDevice->Present(nullptr, nullptr, nullptr, nullptr);
		return false;
	}

	return true;
}

//=============================================================================
// `̌ɍs 
//=============================================================================
void CRenderer::DrawEnd(void)
{
	// Direct3Dɂ`̏I
	m_pD3DDevice->EndScene();

	// obNobt@ƃtgobt@̓ւ
	m_pD3DDevice->Present(nullptr, nullptr, nullptr, nullptr);
}

//=============================================================================
// D3DDevice̎擾
//=============================================================================
LPDIRECT3DDEVICE9 CRenderer::GetDevice()
{
	return m_pD3DDevice;
}

//=============================================================================
// C[t[̐؂ւ
//=============================================================================
void CRenderer::DrawWireframe(unsigned int key)
{
	// L[{[h̎擾
	CInputKeyboard keyboard = CManager::GetKeyboard();
	// `@̐؂ւ
	if (keyboard.GetPress(key))
	{
#ifdef _DEBUG
		m_pD3DDevice->SetRenderState(D3DRS_FILLMODE, D3DFILL_WIREFRAME);
#endif
	}
	else {
		m_pD3DDevice->SetRenderState(D3DRS_FILLMODE, D3DFILL_SOLID);
	}
}